/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public enum BGIType {
    BYTE(1, Byte.class),
    INTEGER(2, Integer.class),
    STRING(3, String.class),
    STRING_ARRAY(4, String[].class),
    SHORT(5, Short.class),
    LONG(6, Long.class),
    FLOAT(7, Float.class),
    DOUBLE(8, Double.class),
    STREAM(9, Byte[].class),
    BOOLEAN(10, Boolean.class),
    UUID(11, UUID.class);

    public final byte typeId;
    public final Class<?> typeClass;
    private static final Map<Byte, BGIType> BY_ID;

    private BGIType(byte typeId, Class<?> typeClass) {
        this.typeId = typeId;
        this.typeClass = typeClass;
    }

    public static BGIType fromTypeId(byte id) {
        return BY_ID.get(id);
    }

    static {
        BY_ID = new HashMap<Byte, BGIType>();
        for (BGIType type : BGIType.values()) {
            BY_ID.put(type.typeId, type);
        }
    }
}

