/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream.object;

import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import dev.bnjc.bglib.stream.object.VersionedStreamObject;
import dev.bnjc.bglib.utils.ByteParser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class GemSocketStreamObject
extends VersionedStreamObject {
    private final List<String> emptySlots = new ArrayList<String>();
    private final List<GemstoneEntry> gemstones = new ArrayList<GemstoneEntry>();

    private GemSocketStreamObject(int key, ByteBuffer buffer) {
        super(key, buffer);
    }

    public static GemSocketStreamObject from(int key, ByteBuffer buffer) throws BGIParseException {
        GemSocketStreamObject gsso = new GemSocketStreamObject(key, buffer);
        gsso.parse();
        return gsso;
    }

    public List<String> getEmptySlots() {
        return this.emptySlots;
    }

    public List<GemstoneEntry> getGemstones() {
        return this.gemstones;
    }

    @Override
    protected void parseBuffer() throws BGIParseException {
        if (this.version > 1) {
            throw new BGIParseException("Unsupported GEM_SOCKET stream version [" + this.version + "]", ErrorCode.UNSUPPORTED_STREAM_VERSION);
        }
        this.emptySlots.addAll(Arrays.stream(ByteParser.getStringArray(this.buffer)).toList());
        int entryCount = ByteParser.getVarInt(this.buffer);
        for (int i = 0; i < entryCount; ++i) {
            String name = ByteParser.getString(this.buffer);
            UUID history = ByteParser.getUUID(this.buffer);
            String id = null;
            if (ByteParser.getBoolean(this.buffer)) {
                id = ByteParser.getString(this.buffer);
            }
            String type = null;
            if (ByteParser.getBoolean(this.buffer)) {
                type = ByteParser.getString(this.buffer);
            }
            String color = null;
            if (ByteParser.getBoolean(this.buffer)) {
                color = ByteParser.getString(this.buffer);
            }
            this.gemstones.add(new GemstoneEntry(name, history, id, type, color));
        }
    }

    @Override
    public String toString() {
        return "GemSocketStreamObject{version=" + this.version + ", gemstones=" + String.valueOf(this.gemstones) + ", emptySlots=" + String.valueOf(this.emptySlots) + "}";
    }

    public record GemstoneEntry(String name, UUID history, @Nullable String id, @Nullable String type, @Nullable String color) {
    }
}

