/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.stream.object.StreamObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BGIData {
    private final int dataVersion;
    private final Map<Integer, Object> properties;

    public BGIData(int dataVersion, Map<Integer, Object> properties) {
        this.dataVersion = dataVersion;
        this.properties = properties;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public int getNumAttributes() {
        return this.properties.size();
    }

    public Optional<Object> getAttribute(String key) {
        return Optional.ofNullable(this.properties.getOrDefault(key.hashCode(), null));
    }

    public Optional<Object> getAttribute(BGIField field) {
        return this.getAttribute(field.name());
    }

    public Optional<String> getString(String key) {
        return this.getAttribute(key).filter(value -> value instanceof String).map(value -> (String)value);
    }

    public Optional<String> getString(BGIField field) {
        return this.getString(field.name());
    }

    public Optional<Integer> getInt(String key) {
        return this.getAttribute(key).filter(value -> value instanceof Integer).map(value -> (Integer)value);
    }

    public Optional<Integer> getInt(BGIField field) {
        return this.getInt(field.name());
    }

    public Optional<Double> getDouble(String key) {
        return this.getAttribute(key).filter(value -> value instanceof Double).map(value -> (Double)value);
    }

    public Optional<Double> getDouble(BGIField field) {
        return this.getDouble(field.name());
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.getAttribute(key).filter(value -> value instanceof Boolean).map(value -> (Boolean)value);
    }

    public Optional<Boolean> getBoolean(BGIField field) {
        return this.getBoolean(field.name());
    }

    public Optional<String[]> getStringArray(String key) {
        return this.getAttribute(key).filter(value -> value instanceof String[]).map(value -> (String[])value);
    }

    public Optional<String[]> getStringArray(BGIField field) {
        return this.getStringArray(field.name());
    }

    public Optional<StreamObject> getStream(String key) {
        return this.getAttribute(key).filter(value -> value instanceof StreamObject).map(value -> (StreamObject)value);
    }

    public Optional<StreamObject> getStream(BGIField field) {
        return this.getStream(field.name());
    }

    public HashMap<String, Object> getAttributesMappedToFieldName() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Map.Entry<Integer, Object> entry : this.properties.entrySet()) {
            attrs.put(BGIField.fromHashCode(entry.getKey()).map(Enum::name).orElse(entry.getKey().toString()), entry.getValue());
        }
        return attrs;
    }

    public String toString() {
        return "BGIData{dataVersion=" + this.dataVersion + ", properties=" + String.valueOf(this.getAttributesMappedToFieldName()) + "}";
    }

    public HashMap<Integer, Object> getAttributes() {
        return new HashMap<Integer, Object>(this.properties);
    }
}

