/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream.object;

import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import dev.bnjc.bglib.stream.object.VersionedStreamObject;
import dev.bnjc.bglib.utils.ByteParser;
import java.nio.ByteBuffer;

public class ArrowParticlesStreamObject
extends VersionedStreamObject {
    private String particle;
    private int amount;
    private double offset;
    private boolean colored;
    private double speed;

    private ArrowParticlesStreamObject(int key, ByteBuffer buffer) {
        super(key, buffer);
    }

    public static ArrowParticlesStreamObject from(int key, ByteBuffer buffer) throws BGIParseException {
        ArrowParticlesStreamObject apso = new ArrowParticlesStreamObject(key, buffer);
        apso.parse();
        return apso;
    }

    public String getParticle() {
        return this.particle;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isColored() {
        return this.colored;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    protected void parseBuffer() throws BGIParseException {
        if (this.version > 1) {
            throw new BGIParseException("Unsupported ARROW_PARTICLES stream version [" + this.version + "]", ErrorCode.UNSUPPORTED_STREAM_VERSION);
        }
        this.particle = ByteParser.getString(this.buffer);
        this.amount = ByteParser.getVarInt(this.buffer);
        this.offset = ByteParser.getDouble(this.buffer);
        this.colored = ByteParser.getBoolean(this.buffer);
        this.speed = ByteParser.getDouble(this.buffer);
    }

    @Override
    public String toString() {
        return "ArrowParticlesStreamObject{particle='" + this.particle + "', amount=" + this.amount + ", offset=" + this.offset + ", colored=" + this.colored + ", speed=" + this.speed + ", version=" + this.version + "}";
    }
}

