/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream;

import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.stream.object.AbilityStreamObject;
import dev.bnjc.bglib.stream.object.ArrowParticlesStreamObject;
import dev.bnjc.bglib.stream.object.CommandStreamObject;
import dev.bnjc.bglib.stream.object.ConsumableBuffStreamObject;
import dev.bnjc.bglib.stream.object.GemSocketStreamObject;
import dev.bnjc.bglib.stream.object.HistoryStreamObject;
import dev.bnjc.bglib.stream.object.StreamObject;
import java.nio.ByteBuffer;

public final class BGIStreamParser {
    public static StreamObject parse(int key, byte[] streamBytes) throws BGIParseException {
        if (streamBytes.length == 0) {
            throw new BGIParseException("Empty stream data");
        }
        ByteBuffer buffer = ByteBuffer.wrap(streamBytes);
        if (BGIField.COMMANDS.key() == key) {
            return CommandStreamObject.from(key, buffer);
        }
        if (BGIField.ABILITY.key() == key) {
            return AbilityStreamObject.from(key, buffer);
        }
        if (BGIField.ARROW_PARTICLES.key() == key) {
            return ArrowParticlesStreamObject.from(key, buffer);
        }
        if (BGIField.CONSUMABLE_BUFFS.key() == key) {
            return ConsumableBuffStreamObject.from(key, buffer);
        }
        if (BGIField.GEM_SOCKETS.key() == key) {
            return GemSocketStreamObject.from(key, buffer);
        }
        return HistoryStreamObject.from(key, buffer);
    }
}

