/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.utils;

import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import dev.bnjc.bglib.stream.BGIStreamParser;
import dev.bnjc.bglib.stream.object.StreamObject;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class ByteParser {
    private ByteParser() {
    }

    public static Object getByType(int key, ByteBuffer buffer) throws BGIParseException {
        byte typeId = ByteParser.getByte(buffer);
        return switch (typeId) {
            case 1 -> ByteParser.getByte(buffer);
            case 2 -> ByteParser.getVarInt(buffer);
            case 3 -> ByteParser.getString(buffer);
            case 4 -> ByteParser.getStringArray(buffer);
            case 5 -> ByteParser.getShort(buffer);
            case 6 -> ByteParser.getLong(buffer);
            case 7 -> Float.valueOf(ByteParser.getFloat(buffer));
            case 8 -> ByteParser.getDouble(buffer);
            case 9 -> ByteParser.getStream(key, buffer);
            case 10 -> ByteParser.getBoolean(buffer);
            case 11 -> ByteParser.getUUID(buffer);
            default -> throw new BGIParseException("Could not parse data type [" + typeId + "]", ErrorCode.UNKNOWN_DATA_TYPE);
        };
    }

    public static byte getByte(ByteBuffer buffer) {
        return buffer.get();
    }

    public static short getShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static long getLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static float getFloat(ByteBuffer buffer) {
        return buffer.getFloat();
    }

    public static double getDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static boolean getBoolean(ByteBuffer buffer) {
        return ByteParser.getByte(buffer) != 0;
    }

    public static String getString(ByteBuffer buffer) {
        int length = ByteParser.getVarInt(buffer);
        byte[] strBytes = new byte[length];
        buffer.get(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    public static String[] getStringArray(ByteBuffer buffer) {
        int count = ByteParser.getVarInt(buffer);
        String[] array = new String[count];
        for (int j = 0; j < count; ++j) {
            array[j] = ByteParser.getString(buffer);
        }
        return array;
    }

    public static StreamObject getStream(int key, ByteBuffer buffer) throws BGIParseException {
        int length = ByteParser.getVarInt(buffer);
        byte[] streamBytes = new byte[length];
        buffer.get(streamBytes);
        return BGIStreamParser.parse(key, streamBytes);
    }

    public static int getInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static int getVarInt(ByteBuffer buffer) {
        int value = 0;
        int shift = 0;
        while (buffer.hasRemaining()) {
            byte b = ByteParser.getByte(buffer);
            int temp = b & 0x7F;
            value |= temp << shift;
            if ((b & 0x80) == 0) break;
            if ((shift += 7) <= 32) continue;
            throw new IllegalArgumentException("Malformed variable int");
        }
        return value;
    }

    public static UUID getUUID(ByteBuffer buffer) {
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

