/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream.object;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public abstract class StreamObject {
    protected final int key;
    protected final ByteBuffer buffer;

    public StreamObject(int key, ByteBuffer buffer) {
        this.key = key;
        this.buffer = buffer;
    }

    protected String readIdentifier() {
        byte b;
        int start = this.buffer.position();
        while (this.buffer.hasRemaining() && this.isLetterOrUnderscore(b = this.buffer.get(this.buffer.position()))) {
            this.buffer.get();
        }
        int end = this.buffer.position();
        byte[] bytes = new byte[end - start];
        this.buffer.position(start);
        this.buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private boolean isLetterOrUnderscore(byte b) {
        return b >= 65 && b <= 90 || b >= 97 && b <= 122 || b == 95;
    }

    public String toString() {
        return "StreamObject{buffer=" + Arrays.toString(this.buffer.array()) + "}";
    }
}

