/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream.object;

import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.stream.object.StreamObject;
import dev.bnjc.bglib.utils.ByteParser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class HistoryStreamObject
extends StreamObject {
    private String statName;
    private List<HistoryEntry> ogStories = new ArrayList<HistoryEntry>();
    private List<GemStory> gemStories = new ArrayList<GemStory>();
    private List<ModStory> modStories = new ArrayList<ModStory>();
    private boolean unknown1 = false;

    public HistoryStreamObject(int key, ByteBuffer buffer) {
        super(key, buffer);
        try {
            this.parseBuffer();
        }
        catch (BGIParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getStatName() {
        return this.statName;
    }

    public List<GemStory> getGemStories() {
        return this.gemStories;
    }

    public boolean hasGemStories() {
        return !this.gemStories.isEmpty();
    }

    public List<HistoryEntry> getOgStories() {
        return this.ogStories;
    }

    public boolean hasOGStories() {
        return !this.ogStories.isEmpty();
    }

    public List<ModStory> getModStories() {
        return this.modStories;
    }

    public boolean hasModStories() {
        return !this.modStories.isEmpty();
    }

    private void parseBuffer() throws BGIParseException {
        boolean hasGemStory;
        this.statName = ByteParser.getString(this.buffer);
        boolean hasOGStory = ByteParser.getBoolean(this.buffer);
        if (hasOGStory) {
            int entryCount = ByteParser.getVarInt(this.buffer);
            for (int i = 0; i < entryCount; ++i) {
                String key = ByteParser.getString(this.buffer);
                Object value = ByteParser.getByType(key.hashCode(), this.buffer);
                this.ogStories.add(new HistoryEntry(key, value));
            }
        }
        if (hasGemStory = ByteParser.getBoolean(this.buffer)) {
            int storyCount = ByteParser.getVarInt(this.buffer);
            for (int i = 0; i < storyCount; ++i) {
                UUID key = ByteParser.getUUID(this.buffer);
                int entryCount = ByteParser.getVarInt(this.buffer);
                ArrayList<HistoryEntry> gems = new ArrayList<HistoryEntry>();
                for (int e = 0; e < entryCount; ++e) {
                    String entryKey = ByteParser.getString(this.buffer);
                    Object value = ByteParser.getByType(entryKey.hashCode(), this.buffer);
                    gems.add(new HistoryEntry(entryKey, value));
                }
                this.gemStories.add(new GemStory(key, gems));
            }
        }
        this.unknown1 = ByteParser.getBoolean(this.buffer);
        boolean hasModStory = ByteParser.getBoolean(this.buffer);
        if (hasModStory) {
            int storyCount = ByteParser.getVarInt(this.buffer);
            for (int i = 0; i < storyCount; ++i) {
                UUID key = ByteParser.getUUID(this.buffer);
                int entryCount = ByteParser.getVarInt(this.buffer);
                ArrayList<HistoryEntry> mods = new ArrayList<HistoryEntry>();
                for (int e = 0; e < entryCount; ++e) {
                    String entryKey = ByteParser.getString(this.buffer);
                    Object value = ByteParser.getByType(entryKey.hashCode(), this.buffer);
                    mods.add(new HistoryEntry(entryKey, value));
                }
                this.modStories.add(new ModStory(key, mods));
            }
        }
    }

    @Override
    public String toString() {
        return "HistoryStreamObject{statName='" + this.statName + "', ogStories=" + String.valueOf(this.ogStories) + ", gemStories=" + String.valueOf(this.gemStories) + ", modStories=" + String.valueOf(this.modStories) + ", unknown1=" + this.unknown1 + "}";
    }

    public record HistoryEntry(String key, Object value) {
    }

    public record GemStory(UUID key, List<HistoryEntry> entries) {
    }

    public record ModStory(UUID key, List<HistoryEntry> entries) {
    }
}

