/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream.object;

import dev.bnjc.bglib.stream.object.StreamObject;
import dev.bnjc.bglib.utils.ByteParser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class GemSocketStreamObject
extends StreamObject {
    private final List<String> emptySlots = new ArrayList<String>();
    private final List<GemstoneEntry> gemstones = new ArrayList<GemstoneEntry>();

    public GemSocketStreamObject(int key, ByteBuffer buffer) {
        super(key, buffer);
        this.parseBuffer();
    }

    public List<String> getEmptySlots() {
        return this.emptySlots;
    }

    public List<GemstoneEntry> getGemstones() {
        return this.gemstones;
    }

    private void parseBuffer() {
        boolean hasEmptySlots = ByteParser.getBoolean(this.buffer);
        if (hasEmptySlots) {
            this.emptySlots.addAll(Arrays.stream(ByteParser.getStringArray(this.buffer)).toList());
        }
        int entryCount = ByteParser.getVarInt(this.buffer);
        for (int i = 0; i < entryCount; ++i) {
            String name = ByteParser.getString(this.buffer);
            UUID history = ByteParser.getUUID(this.buffer);
            String id = null;
            if (ByteParser.getBoolean(this.buffer)) {
                id = ByteParser.getString(this.buffer);
            }
            String type = null;
            if (ByteParser.getBoolean(this.buffer)) {
                type = ByteParser.getString(this.buffer);
            }
            String color = null;
            if (ByteParser.getBoolean(this.buffer)) {
                color = ByteParser.getString(this.buffer);
            }
            this.gemstones.add(new GemstoneEntry(name, history, id, type, color));
        }
    }

    @Override
    public String toString() {
        return "GemSocketStreamObject{emptySlots=" + String.valueOf(this.emptySlots) + ", gemstones=" + String.valueOf(this.gemstones) + "}";
    }

    public record GemstoneEntry(String name, UUID history, @Nullable String id, @Nullable String type, @Nullable String color) {
    }
}

