/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib.stream.object;

import dev.bnjc.bglib.stream.object.StreamObject;
import dev.bnjc.bglib.utils.ByteParser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsumableBuffStreamObject
extends StreamObject {
    private final Map<String, List<Buff>> buffTypes = new HashMap<String, List<Buff>>();

    public ConsumableBuffStreamObject(int key, ByteBuffer buffer) {
        super(key, buffer);
        this.parseBuffer();
    }

    public Map<String, List<Buff>> getBuffTypes() {
        return this.buffTypes;
    }

    private void parseBuffer() {
        int buffTypeCount = ByteParser.getVarInt(this.buffer);
        for (int b = 0; b < buffTypeCount; ++b) {
            String type = ByteParser.getString(this.buffer);
            this.buffTypes.put(type, new ArrayList());
            int buffCount = ByteParser.getVarInt(this.buffer);
            for (int i = 0; i < buffCount; ++i) {
                this.buffTypes.computeIfPresent(type, (s, buffs) -> {
                    buffs.add(new Buff(ByteParser.getDouble(this.buffer), ByteParser.getDouble(this.buffer), ByteParser.getString(this.buffer), ByteParser.getString(this.buffer), ByteParser.getString(this.buffer), ByteParser.getDouble(this.buffer)));
                    return buffs;
                });
            }
        }
    }

    @Override
    public String toString() {
        return "ConsumableBuffStreamObject{buffTypes=" + String.valueOf(this.buffTypes) + "}";
    }

    public record Buff(double amountNew, double time, String stat, String key, String type, double loreMultiplier) {
    }
}

