/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIData;
import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.BGIParseResult;
import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import dev.bnjc.bglib.utils.ByteParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class BGIParser {
    public static final String BGI_TAG = "bgi";
    private final ByteBuffer buffer;
    private final byte[] originalData;

    private BGIParser(byte[] data) {
        this.originalData = data;
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public static BGIParseResult<BGIData> parse(byte[] data) {
        BGIParser parser = new BGIParser(data);
        return parser.parse();
    }

    public static BGIParseResult<BGIData> parse(class_1799 itemStack) {
        class_2487 stackNbt = ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (stackNbt != null && stackNbt.method_10573(BGI_TAG, 7)) {
            return BGIParser.parse(stackNbt.method_10547(BGI_TAG));
        }
        return BGIParseResult.error(ErrorCode.MISSING_TAG);
    }

    public static Optional<BGIField> getFieldFromHash(int hashCode) {
        for (BGIField field : BGIField.values()) {
            if (field.name().hashCode() != hashCode) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private BGIParseResult<BGIData> parse() {
        if (this.originalData.length < 5) {
            return BGIParseResult.error(ErrorCode.DATA_TOO_SHORT);
        }
        if (this.originalData[0] != 7) {
            return BGIParseResult.error(ErrorCode.GOBLINLESS);
        }
        this.buffer.position(1);
        try {
            short dataVersion = ByteParser.getShort(this.buffer);
            Map<Integer, Object> properties = this.parseProperties();
            return BGIParseResult.success(new BGIData(dataVersion, properties));
        }
        catch (BGIParseException e) {
            return BGIParseResult.error(e);
        }
    }

    private Map<Integer, Object> parseProperties() throws BGIParseException {
        int numAttributes = ByteParser.getShort(this.buffer);
        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
        for (int i = 0; i < numAttributes; ++i) {
            int key = ByteParser.getInt(this.buffer);
            try {
                Object value = ByteParser.getByType(key, this.buffer);
                properties.put(key, value);
                continue;
            }
            catch (Exception e) {
                System.out.println(key + " " + e.getMessage());
                properties.put(key, null);
            }
        }
        return properties;
    }

    public static void main(String[] args) {
    }
}

