/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIData;
import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.BGIParseResult;
import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class BGIParser {
    public static final String BGI_TAG = "bgi";
    private final ByteBuffer buffer;
    private final byte[] originalData;

    private BGIParser(byte[] data) {
        this.originalData = data;
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public static BGIParseResult<BGIData> parse(byte[] data) {
        BGIParser parser = new BGIParser(data);
        return parser.parse();
    }

    public static BGIParseResult<BGIData> parse(class_1799 itemStack) {
        class_2487 stackNbt = ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (stackNbt != null && stackNbt.method_10573(BGI_TAG, 7)) {
            return BGIParser.parse(stackNbt.method_10547(BGI_TAG));
        }
        return BGIParseResult.error(ErrorCode.MISSING_TAG);
    }

    public static Optional<BGIField> getFieldFromHash(int hashCode) {
        for (BGIField field : BGIField.values()) {
            if (field.name().hashCode() != hashCode) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private BGIParseResult<BGIData> parse() {
        if (this.originalData.length < 5) {
            return BGIParseResult.error(ErrorCode.DATA_TOO_SHORT);
        }
        if (this.originalData[0] != 7) {
            return BGIParseResult.error(ErrorCode.GOBLINLESS);
        }
        this.buffer.position(1);
        try {
            short dataVersion = this.getShort();
            Map<Integer, Object> properties = this.parseProperties();
            return BGIParseResult.success(new BGIData(dataVersion, properties));
        }
        catch (BGIParseException e) {
            return BGIParseResult.error(e);
        }
    }

    private Map<Integer, Object> parseProperties() throws BGIParseException {
        int numAttributes = this.getShort();
        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
        for (int i = 0; i < numAttributes; ++i) {
            int key = this.getInt();
            byte typeId = this.getByte();
            Object value = switch (typeId) {
                case 2 -> this.getVarInt();
                case 3 -> this.getString();
                case 4 -> this.getStringArray();
                case 8 -> this.getDouble();
                case 9 -> (Object)this.getStream();
                case 10 -> this.getBoolean();
                case 11 -> this.getUUID();
                default -> throw new BGIParseException("Could not parse data type [" + typeId + "]", ErrorCode.UNKNOWN_DATA_TYPE);
            };
            properties.put(key, value);
        }
        return properties;
    }

    private byte getByte() {
        return this.buffer.get();
    }

    private short getShort() {
        return this.buffer.getShort();
    }

    private double getDouble() {
        return this.buffer.getDouble();
    }

    private boolean getBoolean() {
        return this.getByte() != 0;
    }

    private String getString() {
        int length = this.getVarInt();
        byte[] strBytes = new byte[length];
        this.buffer.get(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    private String[] getStringArray() {
        int count = this.getVarInt();
        String[] array = new String[count];
        for (int j = 0; j < count; ++j) {
            array[j] = this.getString();
        }
        return array;
    }

    private byte[] getStream() {
        int length = this.getVarInt();
        byte[] streamBytes = new byte[length];
        this.buffer.get(streamBytes);
        return streamBytes;
    }

    private int getInt() {
        return this.buffer.getInt();
    }

    private int getVarInt() {
        int value = 0;
        int shift = 0;
        while (this.buffer.hasRemaining()) {
            byte b = this.getByte();
            int temp = b & 0x7F;
            value |= temp << shift;
            if ((b & 0x80) == 0) break;
            if ((shift += 7) <= 32) continue;
            throw new IllegalArgumentException("Malformed variable int");
        }
        return value;
    }

    private UUID getUUID() {
        long mostSigBits = this.buffer.getLong();
        long leastSigBits = this.buffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public static void main(String[] args) {
        byte[] item1 = new byte[]{7, 0, 1, 0, 20, -122, -31, 26, 32, 8, 64, 57, 50, -83, 74, 64, 57, -9, -113, -89, -67, -85, 3, 9, 82, 65, 82, 69, 95, 71, 69, 65, 82, -108, 65, 47, 58, 4, 0, -103, -106, 9, -23, 9, 25, 8, 69, 78, 67, 72, 65, 78, 84, 83, 1, 1, 8, 69, 78, 67, 72, 65, 78, 84, 83, 4, 0, 0, 0, 0, -98, -12, -13, -1, 2, 1, -88, -18, -67, -57, 3, 17, 67, 72, 69, 70, 95, 67, 72, 69, 83, 84, 80, 76, 65, 84, 69, 95, 51, -86, -14, 60, -67, 8, 64, 77, -98, -23, -63, 106, -93, -45, -84, -126, 1, -28, 2, -24, 7, -48, 7, 51, 73, 3, 17, 67, 72, 69, 70, 95, 67, 72, 69, 83, 84, 80, 76, 65, 84, 69, 95, 51, -27, -110, 92, -84, 3, 14, 80, 79, 87, 68, 69, 82, 124, 67, 79, 82, 69, 95, 84, 51, -17, 17, -96, -92, 3, 9, 110, 101, 116, 104, 101, 114, 105, 116, 101, -7, -91, 118, 48, 9, 27, 1, 2, 11, 82, 117, 110, 101, 99, 97, 114, 118, 105, 110, 103, 11, 82, 117, 110, 101, 99, 97, 114, 118, 105, 110, 103, 0, 0, 1, 64, 66, 3, 8, 83, 69, 84, 95, 67, 72, 69, 70, 0, 35, -66, -10, 4, 1, 35, 38, 55, 77, 97, 100, 101, 32, 102, 114, 111, 109, 32, 111, 110, 108, 121, 32, 116, 104, 101, 32, 102, 105, 110, 101, 115, 116, 32, 112, 111, 116, 97, 116, 111, 46, 0, 36, 114, -117, 3, 38, 60, 116, 105, 101, 114, 45, 99, 111, 108, 111, 114, 62, 74, 111, 117, 114, 110, 101, 121, 109, 97, 110, 32, 67, 104, 101, 102, 115, 32, 84, 97, 116, 101, 114, 32, 84, 111, 112, 0, 39, 73, -30, 8, 64, 8, 0, 0, 0, 0, 0, 0, 1, 70, 72, 83, 3, 3, 118, 101, 120, 12, 71, 3, -8, 3, 19, -62, -85, 32, 67, 111, 111, 107, 105, 110, 103, 32, 65, 114, 109, 111, 114, 32, -62, -69, 34, -107, 32, -1, 8, 64, 52, 0, 0, 0, 0, 0, 0, 40, 59, -64, -26, 3, 5, 65, 82, 77, 79, 82};
        BGIParseResult<BGIData> result = BGIParser.parse(item1);
        if (result.isSuccess()) {
            BGIData data = result.result().get();
            System.out.println(data.getString("ItemId"));
            System.out.println("Num Attributes: " + data.getNumAttributes());
            HashMap<Integer, Object> attrs = data.getAttributes();
            System.out.println(attrs.get(-804834487));
            for (Integer key : attrs.keySet()) {
                boolean found = false;
                for (BGIField field : BGIField.values()) {
                    if (field.name().hashCode() != key.intValue()) continue;
                    Object value = attrs.get(key);
                    if (value instanceof String[]) {
                        System.out.println(String.valueOf((Object)field) + " = " + Arrays.toString((String[])value));
                    } else {
                        System.out.println(String.valueOf((Object)field) + " = " + String.valueOf(value));
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println(key + " = " + String.valueOf(attrs.get(key)));
            }
        } else {
            System.out.println(result.error().get().getMessage());
        }
    }
}

