/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIData;
import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.BGIParseResult;
import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class BGIParser {
    public static final String BGI_TAG = "bgi";
    private final ByteBuffer buffer;
    private final byte[] originalData;

    private BGIParser(byte[] data) {
        this.originalData = data;
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public static BGIParseResult<BGIData> parse(byte[] data) {
        BGIParser parser = new BGIParser(data);
        return parser.parse();
    }

    public static BGIParseResult<BGIData> parse(class_1799 itemStack) {
        class_2487 stackNbt = ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (stackNbt != null && stackNbt.method_10573(BGI_TAG, 7)) {
            return BGIParser.parse(stackNbt.method_10547(BGI_TAG));
        }
        return BGIParseResult.error(ErrorCode.MISSING_TAG);
    }

    public static Optional<BGIField> getFieldFromHash(int hashCode) {
        for (BGIField field : BGIField.values()) {
            if (field.name().hashCode() != hashCode) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private BGIParseResult<BGIData> parse() {
        if (this.originalData.length < 5) {
            return BGIParseResult.error(ErrorCode.DATA_TOO_SHORT);
        }
        if (this.originalData[0] != 7) {
            return BGIParseResult.error(ErrorCode.GOBLINLESS);
        }
        this.buffer.position(1);
        try {
            short dataVersion = this.getShort();
            Map<Integer, Object> properties = this.parseProperties();
            return BGIParseResult.success(new BGIData(dataVersion, properties));
        }
        catch (BGIParseException e) {
            return BGIParseResult.error(e);
        }
    }

    private Map<Integer, Object> parseProperties() throws BGIParseException {
        int numAttributes = this.getShort();
        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
        for (int i = 0; i < numAttributes; ++i) {
            int key = this.getInt();
            byte typeId = this.getByte();
            Object value = switch (typeId) {
                case 2 -> this.getVarInt();
                case 3 -> this.getString();
                case 4 -> this.getStringArray();
                case 8 -> this.getDouble();
                case 9 -> (Object)this.getStream();
                case 10 -> this.getBoolean();
                case 11 -> this.getUUID();
                default -> throw new BGIParseException("Could not parse data type [" + typeId + "]", ErrorCode.UNKNOWN_DATA_TYPE);
            };
            properties.put(key, value);
        }
        return properties;
    }

    private byte getByte() {
        return this.buffer.get();
    }

    private short getShort() {
        return this.buffer.getShort();
    }

    private double getDouble() {
        return this.buffer.getDouble();
    }

    private boolean getBoolean() {
        return this.getByte() != 0;
    }

    private String getString() {
        int length = this.getVarInt();
        byte[] strBytes = new byte[length];
        this.buffer.get(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    private String[] getStringArray() {
        int count = this.getVarInt();
        String[] array = new String[count];
        for (int j = 0; j < count; ++j) {
            array[j] = this.getString();
        }
        return array;
    }

    private byte[] getStream() {
        int length = this.getVarInt();
        byte[] streamBytes = new byte[length];
        this.buffer.get(streamBytes);
        return streamBytes;
    }

    private int getInt() {
        return this.buffer.getInt();
    }

    private int getVarInt() {
        int value = 0;
        int shift = 0;
        while (this.buffer.hasRemaining()) {
            byte b = this.getByte();
            int temp = b & 0x7F;
            value |= temp << shift;
            if ((b & 0x80) == 0) break;
            if ((shift += 7) <= 32) continue;
            throw new IllegalArgumentException("Malformed variable int");
        }
        return value;
    }

    private UUID getUUID() {
        long mostSigBits = this.buffer.getLong();
        long leastSigBits = this.buffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

