/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIData;
import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.BGIParseResult;
import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class BGIParser {
    public static final String BGI_TAG = "bgi";
    private final ByteBuffer buffer;
    private final byte[] originalData;

    private BGIParser(byte[] data) {
        this.originalData = data;
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public static BGIParseResult<BGIData> parse(byte[] data) {
        BGIParser parser = new BGIParser(data);
        return parser.parse();
    }

    public static BGIParseResult<BGIData> parse(class_1799 itemStack) {
        class_2487 stackNbt = ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (stackNbt != null && stackNbt.method_10573(BGI_TAG, 7)) {
            return BGIParser.parse(stackNbt.method_10547(BGI_TAG));
        }
        return BGIParseResult.error(ErrorCode.MISSING_TAG);
    }

    private BGIParseResult<BGIData> parse() {
        if (this.originalData.length < 5) {
            return BGIParseResult.error(ErrorCode.DATA_TOO_SHORT);
        }
        if (this.originalData[0] != 7) {
            return BGIParseResult.error(ErrorCode.GOBLINLESS);
        }
        this.buffer.position(1);
        try {
            short dataVersion = this.getShort();
            Map<Integer, Object> properties = this.parseProperties();
            return BGIParseResult.success(new BGIData(dataVersion, properties));
        }
        catch (BGIParseException e) {
            return BGIParseResult.error(e);
        }
    }

    private Map<Integer, Object> parseProperties() throws BGIParseException {
        int numAttributes = this.getShort();
        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
        for (int i = 0; i < numAttributes; ++i) {
            int key = this.getInt();
            byte typeId = this.getByte();
            Object value = switch (typeId) {
                case 2 -> this.getVarInt();
                case 3 -> this.getString();
                case 4 -> this.getStringArray();
                case 8 -> this.getDouble();
                case 9 -> (Object)this.getStream();
                case 10 -> this.getBoolean();
                default -> throw new BGIParseException("Could not parse data type [" + typeId + "]", ErrorCode.UNKNOWN_DATA_TYPE);
            };
            properties.put(key, value);
        }
        return properties;
    }

    private byte getByte() {
        return this.buffer.get();
    }

    private short getShort() {
        return this.buffer.getShort();
    }

    private double getDouble() {
        return this.buffer.getDouble();
    }

    private boolean getBoolean() {
        return this.getByte() != 0;
    }

    private String getString() {
        int length = this.getVarInt();
        byte[] strBytes = new byte[length];
        this.buffer.get(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    private String[] getStringArray() {
        int count = this.getVarInt();
        String[] array = new String[count];
        for (int j = 0; j < count; ++j) {
            array[j] = this.getString();
        }
        return array;
    }

    private byte[] getStream() {
        int length = this.getVarInt();
        byte[] streamBytes = new byte[length];
        this.buffer.get(streamBytes);
        return streamBytes;
    }

    private int getInt() {
        return this.buffer.getInt();
    }

    private int getVarInt() {
        int value = 0;
        int shift = 0;
        while (this.buffer.hasRemaining()) {
            byte b = this.getByte();
            int temp = b & 0x7F;
            value |= temp << shift;
            if ((b & 0x80) == 0) break;
            if ((shift += 7) <= 32) continue;
            throw new IllegalArgumentException("Malformed variable int");
        }
        return value;
    }

    public static void main(String[] args) {
        byte[] item1 = new byte[]{7, 0, 1, 0, 13, -113, -89, -67, -85, 3, 6, 67, 79, 77, 77, 79, 78, -108, 65, 47, 58, 4, 0, -103, -106, 9, -23, 9, 25, 8, 69, 78, 67, 72, 65, 78, 84, 83, 1, 1, 8, 69, 78, 67, 72, 65, 78, 84, 83, 4, 0, 0, 0, 0, -98, -12, -13, -1, 2, 1, -88, -18, -67, -57, 3, 20, 87, 69, 76, 76, 95, 83, 69, 65, 83, 79, 78, 69, 68, 95, 66, 69, 69, 70, 95, 49, -48, 7, 51, 73, 3, 20, 87, 69, 76, 76, 95, 83, 69, 65, 83, 79, 78, 69, 68, 95, 66, 69, 69, 70, 95, 49, 0, 35, -66, -10, 4, 3, 17, 38, 55, 77, 97, 107, 101, 115, 32, 121, 97, 32, 66, 69, 69, 70, 89, 46, 0, 38, 38, 99, 82, 101, 112, 108, 97, 99, 101, 115, 32, 97, 110, 121, 32, 97, 99, 116, 105, 118, 101, 32, -62, -85, 32, 70, 111, 111, 100, 32, -62, -69, 32, 98, 117, 102, 102, 46, 0, 36, 114, -117, 3, 32, 60, 116, 105, 101, 114, 45, 99, 111, 108, 111, 114, 62, 87, 101, 108, 108, 45, 83, 101, 97, 115, 111, 110, 101, 100, 32, 66, 101, 101, 102, 32, 73, 9, -81, 127, 78, 8, 64, 16, 0, 0, 0, 0, 0, 0, 12, 71, 3, -8, 3, 10, -62, -85, 32, 70, 111, 111, 100, 32, -62, -69, 40, 59, -64, -26, 3, 10, 67, 79, 78, 83, 85, 77, 65, 66, 76, 69, 49, -114, -119, 96, 3, 10, 99, 111, 110, 115, 117, 109, 97, 98, 108, 101, 63, -50, -39, -124, 9, -69, 1, 1, 9, 66, 85, 70, 70, 95, 70, 79, 79, 68, 3, -64, 0, 0, 0, 0, 0, 0, 0, 64, -100, 32, 0, 0, 0, 0, 0, 14, 82, 69, 68, 85, 67, 69, 68, 95, 72, 85, 78, 71, 69, 82, 9, 66, 85, 70, 70, 95, 70, 79, 79, 68, 8, 97, 100, 100, 105, 116, 105, 118, 101, 63, -16, 0, 0, 0, 0, 0, 0, 64, 36, 0, 0, 0, 0, 0, 0, 64, -100, 32, 0, 0, 0, 0, 0, 10, 77, 65, 88, 95, 72, 69, 65, 76, 84, 72, 9, 66, 85, 70, 70, 95, 70, 79, 79, 68, 8, 97, 100, 100, 105, 116, 105, 118, 101, 63, -16, 0, 0, 0, 0, 0, 0, 63, -71, -103, -103, -103, -103, -103, -102, 64, -100, 32, 0, 0, 0, 0, 0, 19, 72, 69, 65, 76, 84, 72, 95, 82, 69, 71, 69, 78, 69, 82, 65, 84, 73, 79, 78, 9, 66, 85, 70, 70, 95, 70, 79, 79, 68, 8, 97, 100, 100, 105, 116, 105, 118, 101, 63, -16, 0, 0, 0, 0, 0, 0};
        BGIParseResult<BGIData> result = BGIParser.parse(item1);
        if (result.isSuccess()) {
            BGIData data = result.result().get();
            System.out.println("Num Attributes: " + data.getNumAttributes());
            HashMap<Integer, Object> attrs = data.getAttributes();
            System.out.println(attrs.get(-804834487));
            for (Integer key : attrs.keySet()) {
                boolean found = false;
                for (BGIField field : BGIField.values()) {
                    if (field.name().hashCode() != key.intValue()) continue;
                    System.out.println(String.valueOf((Object)field) + " = " + String.valueOf(attrs.get(key)));
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println(key + " = " + String.valueOf(attrs.get(key)));
            }
        }
    }
}

