/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.LinkedList;

public final class BGIWriter {
    private final Deque<Byte> bytes = new LinkedList<Byte>();
    private final short dataVersion;
    private short propertyCount;

    public BGIWriter(short dataVersion) {
        this.dataVersion = dataVersion;
        this.propertyCount = 0;
    }

    public BGIWriter addInt(String key, int val) {
        this.putPropertyHeader(key, BGIType.INTEGER);
        this.putVarInt(val);
        return this;
    }

    public BGIWriter addString(String key, String val) {
        this.putPropertyHeader(key, BGIType.STRING);
        this.putString(val);
        return this;
    }

    public BGIWriter addStringArray(String key, String[] val) {
        this.putPropertyHeader(key, BGIType.STRING_ARRAY);
        this.putVarInt(val.length);
        for (String s : val) {
            this.putString(s);
        }
        return this;
    }

    public BGIWriter addDouble(String key, double val) {
        this.putPropertyHeader(key, BGIType.DOUBLE);
        this.putDouble(val);
        return this;
    }

    public BGIWriter addBoolean(String key, boolean val) {
        this.putPropertyHeader(key, BGIType.BOOLEAN);
        this.putBoolean(val);
        return this;
    }

    public BGIWriter addStream(String key, byte[] byteArray) {
        this.putPropertyHeader(key, BGIType.STREAM);
        this.putVarInt(byteArray.length);
        this.putBytes(byteArray);
        return this;
    }

    public byte[] write() {
        byte[] result = new byte[this.bytes.size() + 5];
        int i = 0;
        result[i++] = 7;
        for (byte b : ByteBuffer.allocate(2).putShort(this.dataVersion).array()) {
            result[i++] = b;
        }
        for (byte b : ByteBuffer.allocate(2).putShort(this.propertyCount).array()) {
            result[i++] = b;
        }
        Object object = this.bytes.iterator();
        while (object.hasNext()) {
            byte b = (Byte)object.next();
            result[i++] = b;
        }
        return result;
    }

    private void putPropertyHeader(String key, BGIType type) {
        this.putVarInt(key.hashCode());
        this.putByte(type.typeId);
        this.propertyCount = (short)(this.propertyCount + 1);
    }

    private void putByte(byte val) {
        this.bytes.addLast(val);
    }

    private void putBytes(byte[] byteArray) {
        for (byte b : byteArray) {
            this.bytes.addLast(b);
        }
    }

    private void putShort(short val) {
        this.putBytes(ByteBuffer.allocate(2).putShort(val).array());
    }

    private void putVarInt(int val) {
        while ((val & 0xFFFFFF80) != 0) {
            this.bytes.addLast((byte)(val & 0x7F | 0x80));
            val >>>= 7;
        }
        this.bytes.addLast((byte)(val & 0x7F));
    }

    private void putDouble(double val) {
        this.putBytes(ByteBuffer.allocate(8).putDouble(val).array());
    }

    private void putString(String val) {
        byte[] strBytes = val.getBytes(StandardCharsets.UTF_8);
        this.putVarInt(strBytes.length);
        this.putBytes(strBytes);
    }

    private void putBoolean(boolean val) {
        this.putByte((byte)(val ? 1 : 0));
    }
}

