/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIData;
import dev.bnjc.bglib.BGIField;
import dev.bnjc.bglib.BGIParseResult;
import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class BGIParser {
    public static final String BGI_TAG = "bgi";
    private final ByteBuffer buffer;
    private final byte[] originalData;

    private BGIParser(byte[] data) {
        this.originalData = data;
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public static BGIParseResult<BGIData> parse(byte[] data) {
        BGIParser parser = new BGIParser(data);
        return parser.parse();
    }

    public static BGIParseResult<BGIData> parse(class_1799 itemStack) {
        class_2487 stackNbt = ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        if (stackNbt != null && stackNbt.method_10573(BGI_TAG, 7)) {
            return BGIParser.parse(stackNbt.method_10547(BGI_TAG));
        }
        return BGIParseResult.error(ErrorCode.MISSING_TAG);
    }

    private BGIParseResult<BGIData> parse() {
        if (this.originalData.length < 9) {
            return BGIParseResult.error(ErrorCode.DATA_TOO_SHORT);
        }
        if (this.originalData[0] != 7) {
            return BGIParseResult.error(ErrorCode.GOBLINLESS);
        }
        this.buffer.position(1);
        try {
            short dataVersion = this.getShort();
            Map<Integer, Object> properties = this.parseProperties();
            return BGIParseResult.success(new BGIData(dataVersion, properties));
        }
        catch (BGIParseException e) {
            return BGIParseResult.error(e);
        }
    }

    private Map<Integer, Object> parseProperties() throws BGIParseException {
        int numAttributes = this.getShort();
        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
        for (int i = 0; i < numAttributes; ++i) {
            int key = this.getVarInt();
            byte typeId = this.getByte();
            Object value = switch (typeId) {
                case 2 -> this.getVarInt();
                case 3 -> this.getString();
                case 4 -> this.getStringArray();
                case 8 -> this.getDouble();
                case 9 -> (Object)this.getStream();
                case 10 -> this.getBoolean();
                default -> throw new BGIParseException("Could not parse data type [" + typeId + "]", ErrorCode.UNKNOWN_DATA_TYPE);
            };
            properties.put(key, value);
        }
        return properties;
    }

    private byte getByte() {
        return this.buffer.get();
    }

    private short getShort() {
        return this.buffer.getShort();
    }

    private double getDouble() {
        return this.buffer.getDouble();
    }

    private boolean getBoolean() {
        return this.getByte() != 0;
    }

    private String getString() {
        int length = this.getVarInt();
        byte[] strBytes = new byte[length];
        this.buffer.get(strBytes);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    private String[] getStringArray() {
        int count = this.getVarInt();
        String[] array = new String[count];
        for (int j = 0; j < count; ++j) {
            array[j] = this.getString();
        }
        return array;
    }

    private byte[] getStream() {
        int length = this.getVarInt();
        byte[] streamBytes = new byte[length];
        this.buffer.get(streamBytes);
        return streamBytes;
    }

    private int getVarInt() {
        int value = 0;
        int shift = 0;
        while (this.buffer.hasRemaining()) {
            byte b = this.getByte();
            int temp = b & 0x7F;
            value |= temp << shift;
            if ((b & 0x80) == 0) break;
            if ((shift += 7) <= 32) continue;
            throw new IllegalArgumentException("Malformed varint");
        }
        return value;
    }

    public static void main(String[] args) {
        byte[] input = new byte[]{7, 0, 0, 0, 1, 0, 0, 0, 19, 121, -12, 84, -106, 10, 1, -11, -6, 21, 89, 10, 1, 51, -29, 8, -64, 8, 63, -32, 0, 0, 0, 0, 0, 0, 0, 39, 73, -30, 3, 0, 0, 0, 5, 81, 85, 69, 83, 84, 102, -36, -126, -5, 10, 1, -88, -18, -67, -57, 3, 0, 0, 0, 22, 83, 84, 65, 82, 84, 69, 82, 95, 76, 85, 77, 66, 69, 82, 74, 65, 67, 75, 95, 79, 65, 75, 51, -30, -15, -120, 8, 63, -16, 0, 0, 0, 0, 0, 0, -98, -12, -13, -1, 2, 0, 0, 0, 1, 49, -114, -119, 96, 3, 0, 0, 0, 10, 99, 111, 110, 115, 117, 109, 97, 98, 108, 101, 0, 36, 114, -117, 3, 0, 0, 0, 30, 60, 116, 105, 101, 114, 45, 99, 111, 108, 111, 114, 62, 67, 97, 114, 118, 101, 100, 32, 83, 116, 117, 109, 112, 32, 45, 32, 79, 97, 107, -82, -121, 71, 22, 4, 0, 0, 0, 13, 0, 0, 0, 18, 38, 55, -62, -85, 32, 81, 117, 101, 115, 116, 32, 73, 116, 101, 109, 32, -62, -69, 0, 0, 0, 0, 0, 0, 0, 31, 85, 115, 101, 32, 116, 104, 105, 115, 32, 105, 116, 101, 109, 32, 116, 111, 32, 115, 116, 97, 114, 116, 32, 97, 32, 113, 117, 101, 115, 116, 33, 0, 0, 0, 36, 89, 79, 85, 32, 67, 65, 78, 32, 79, 78, 76, 89, 32, 68, 79, 32, 79, 78, 69, 32, 81, 85, 69, 83, 84, 32, 65, 84, 32, 65, 32, 84, 73, 77, 69, 33, 0, 0, 0, 41, 85, 83, 73, 78, 71, 32, 84, 72, 73, 83, 32, 87, 73, 76, 76, 32, 82, 69, 77, 79, 86, 69, 32, 89, 79, 85, 82, 32, 65, 67, 84, 73, 86, 69, 32, 81, 85, 69, 83, 84, 33, 0, 0, 0, 0, 0, 0, 0, 28, 38, 55, 73, 116, 39, 115, 32, 99, 111, 118, 101, 114, 101, 100, 32, 105, 110, 32, 100, 101, 101, 112, 32, 99, 117, 116, 115, 46, 0, 0, 0, 32, 38, 55, 84, 104, 101, 121, 32, 107, 105, 110, 100, 32, 111, 102, 32, 114, 101, 115, 101, 109, 98, 108, 101, 32, 119, 111, 114, 100, 115, 46, 46, 46, 0, 0, 0, 0, 0, 0, 0, 21, 38, 55, 82, 101, 112, 108, 97, 110, 116, 105, 110, 103, 32, 80, 114, 111, 106, 101, 99, 116, 58, 0, 0, 0, 16, 38, 55, 56, 32, 79, 97, 107, 32, 83, 97, 112, 108, 105, 110, 103, 115, 0, 0, 0, 0, 0, 0, 0, 16, 38, 55, 84, 105, 101, 114, 58, 32, -62, -89, 54, 81, 85, 69, 83, 84, 114, -75, -86, -122, 10, 1, 10, -69, -6, -120, 9, 0, 0, 0, 59, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 37, 109, 109, 111, 99, 111, 114, 101, 32, 113, 117, 101, 115, 116, 32, 115, 116, 97, 114, 116, 32, 37, 112, 108, 97, 121, 101, 114, 37, 32, 112, 97, 117, 108, 45, 111, 97, 107, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 35, -66, -10, 4, 0, 0, 0, 9, 0, 0, 0, 31, 85, 115, 101, 32, 116, 104, 105, 115, 32, 105, 116, 101, 109, 32, 116, 111, 32, 115, 116, 97, 114, 116, 32, 97, 32, 113, 117, 101, 115, 116, 33, 0, 0, 0, 36, 89, 79, 85, 32, 67, 65, 78, 32, 79, 78, 76, 89, 32, 68, 79, 32, 79, 78, 69, 32, 81, 85, 69, 83, 84, 32, 65, 84, 32, 65, 32, 84, 73, 77, 69, 33, 0, 0, 0, 41, 85, 83, 73, 78, 71, 32, 84, 72, 73, 83, 32, 87, 73, 76, 76, 32, 82, 69, 77, 79, 86, 69, 32, 89, 79, 85, 82, 32, 65, 67, 84, 73, 86, 69, 32, 81, 85, 69, 83, 84, 33, 0, 0, 0, 0, 0, 0, 0, 28, 38, 55, 73, 116, 39, 115, 32, 99, 111, 118, 101, 114, 101, 100, 32, 105, 110, 32, 100, 101, 101, 112, 32, 99, 117, 116, 115, 46, 0, 0, 0, 32, 38, 55, 84, 104, 101, 121, 32, 107, 105, 110, 100, 32, 111, 102, 32, 114, 101, 115, 101, 109, 98, 108, 101, 32, 119, 111, 114, 100, 115, 46, 46, 46, 0, 0, 0, 0, 0, 0, 0, 21, 38, 55, 82, 101, 112, 108, 97, 110, 116, 105, 110, 103, 32, 80, 114, 111, 106, 101, 99, 116, 58, 0, 0, 0, 16, 38, 55, 56, 32, 79, 97, 107, 32, 83, 97, 112, 108, 105, 110, 103, 115, 16, -73, 70, -64, 10, 1, 83, 52, -46, -52, 3, 0, 0, 0, 21, 69, 78, 84, 73, 84, 89, 95, 80, 76, 65, 89, 69, 82, 95, 76, 69, 86, 69, 76, 85, 80, -108, 65, 47, 58, 4, 0, 0, 0, 1, 0, 0, 0, 12, 117, 110, 98, 114, 101, 97, 107, 105, 110, 103, 32, 49, 40, 59, -64, -26, 3, 0, 0, 0, 5, 81, 85, 69, 83, 84, -103, -106, 9, -23, 3, 0, 0, 0, 19, 123, 34, 83, 116, 97, 116, 34, 58, 34, 69, 78, 67, 72, 65, 78, 84, 83, 34, 125};
        BGIParseResult<BGIData> data = BGIParser.parse(input);
        data.ifSuccess(item -> {
            System.out.println(item);
            Optional<String> itemId = item.getString(BGIField.ITEM_ID);
            itemId.ifPresent(System.out::println);
        });
    }
}

