/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.exceptions.BGIParseException;
import dev.bnjc.bglib.exceptions.ErrorCode;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BGIParseResult<T> {
    public boolean isSuccess() {
        return this instanceof BGIParseSuccess;
    }

    public boolean isError() {
        return this instanceof BGIParseError;
    }

    public Optional<T> result() {
        if (this.isSuccess()) {
            return Optional.of(((BGIParseSuccess)this).value);
        }
        return Optional.empty();
    }

    public Optional<BGIParseException> error() {
        if (this.isError()) {
            return Optional.of(((BGIParseError)this).error);
        }
        return Optional.empty();
    }

    public static <T> BGIParseSuccess<T> success(T value) {
        return new BGIParseSuccess<T>(value);
    }

    public static <T> BGIParseError<T> error(BGIParseException error) {
        return new BGIParseError(error);
    }

    public static <T> BGIParseError<T> error(String error) {
        return new BGIParseError(new BGIParseException(error));
    }

    public static <T> BGIParseError<T> error(String error, ErrorCode code) {
        return new BGIParseError(new BGIParseException(error, code));
    }

    public static <T> BGIParseError<T> error(ErrorCode code) {
        return new BGIParseError(new BGIParseException(code));
    }

    public abstract BGIParseResult<T> ifSuccess(Consumer<T> var1);

    public abstract BGIParseResult<T> ifError(Consumer<BGIParseException> var1);

    public abstract <R> R mapOrElse(Function<? super T, ? extends R> var1, Function<? super BGIParseError<T>, ? extends R> var2);

    public static class BGIParseSuccess<T>
    extends BGIParseResult<T> {
        private final T value;

        public BGIParseSuccess(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public BGIParseResult<T> ifSuccess(Consumer<T> consumer) {
            consumer.accept(this.value);
            return this;
        }

        @Override
        public BGIParseResult<T> ifError(Consumer<BGIParseException> consumer) {
            return this;
        }

        @Override
        public <R> R mapOrElse(Function<? super T, ? extends R> successFunction, Function<? super BGIParseError<T>, ? extends R> errorFunction) {
            return successFunction.apply(this.value);
        }
    }

    public static class BGIParseError<T>
    extends BGIParseResult<T> {
        private final BGIParseException error;

        public BGIParseError(BGIParseException error) {
            this.error = error;
        }

        public BGIParseException getError() {
            return this.error;
        }

        @Override
        public BGIParseResult<T> ifSuccess(Consumer<T> consumer) {
            return this;
        }

        @Override
        public BGIParseResult<T> ifError(Consumer<BGIParseException> consumer) {
            consumer.accept(this.error);
            return this;
        }

        @Override
        public <R> R mapOrElse(Function<? super T, ? extends R> successFunction, Function<? super BGIParseError<T>, ? extends R> errorFunction) {
            return errorFunction.apply(this);
        }
    }
}

