/*
 * Decompiled with CFR 0.152.
 */
package dev.bnjc.bglib;

import dev.bnjc.bglib.BGIField;
import java.util.Map;
import java.util.Optional;

public class BGIData {
    private final int dataVersion;
    private final Map<Integer, Object> properties;

    public BGIData(int dataVersion, Map<Integer, Object> properties) {
        this.dataVersion = dataVersion;
        this.properties = properties;
    }

    public Optional<Object> getAttribute(String key) {
        return Optional.ofNullable(this.properties.getOrDefault(key.hashCode(), null));
    }

    public Optional<Object> getAttribute(BGIField field) {
        return this.getAttribute(field.name());
    }

    public Optional<String> getString(String key) {
        return this.getAttribute(key).filter(value -> value instanceof String).map(value -> (String)value);
    }

    public Optional<String> getString(BGIField field) {
        return this.getString(field.name());
    }

    public Optional<Integer> getInt(String key) {
        return this.getAttribute(key).filter(value -> value instanceof Integer).map(value -> (Integer)value);
    }

    public Optional<Integer> getInt(BGIField field) {
        return this.getInt(field.name());
    }

    public Optional<Double> getDouble(String key) {
        return this.getAttribute(key).filter(value -> value instanceof Double).map(value -> (Double)value);
    }

    public Optional<Double> getDouble(BGIField field) {
        return this.getDouble(field.name());
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.getAttribute(key).filter(value -> value instanceof Boolean).map(value -> (Boolean)value);
    }

    public Optional<Boolean> getBoolean(BGIField field) {
        return this.getBoolean(field.name());
    }

    public Optional<String[]> getStringArray(String key) {
        return this.getAttribute(key).filter(value -> value instanceof String[]).map(value -> (String[])value);
    }

    public Optional<String[]> getStringArray(BGIField field) {
        return this.getStringArray(field.name());
    }

    public Optional<byte[]> getStream(String key) {
        return this.getAttribute(key).filter(value -> value instanceof byte[]).map(value -> (byte[])value);
    }

    public Optional<byte[]> getStream(BGIField field) {
        return this.getStream(field.name());
    }

    public String toString() {
        return "BGIData{dataVersion=" + this.dataVersion + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

